module.exports = {
    "env": {
        "browser": true,
        "es6": true,
        "amd": true,
        "jasmine": true,
        "jquery": true
    },
    "extends": "eslint:recommended",
    "globals" : {
        "gas": true,
        "google": true,
    },
    overrides: [{
        "files": ["*Spec.js", "*spec.js"],
        "rules": {
            "no-magic-numbers": "never",
            "max-len": "never"
        }
    }],
    "rules": {
        "indent": [
            "error",
            4
        ],
        "linebreak-style": [
            "error",
            "unix"
        ],
        "quotes": [2, 'single', {allowTemplateLiterals: true, avoidEscape: true}],
        "semi": [
            "error",
            "always"
        ],
        'for-direction': "off",
        'no-await-in-loop': "off",
        'no-compare-neg-zero': "error", // eslint:recommended
        'no-cond-assign': "error", // eslint:recommended
        'no-console': "off", // eslint:recommended
        'no-constant-condition': "error", // eslint:recommended
        'no-control-regex': "error", // eslint:recommended
        'no-debugger': "error", // eslint:recommended
        'no-dupe-args': "error", // eslint:recommended
        'no-dupe-keys': "error", // eslint:recommended
        'no-duplicate-case': "error", // eslint:recommended
        'no-empty': "error", // eslint:recommended
        'no-empty-character-class': "error", // eslint:recommended
        'no-ex-assign': "error", // eslint:recommended
        'no-extra-boolean-cast': "error", // eslint:recommended
        'no-extra-parens': "off",
        'no-extra-semi': "error", // eslint:recommended
        'no-func-assign': "error", // eslint:recommended
        'no-inner-declarations': "error", // eslint:recommended
        'no-invalid-regexp': "error", // eslint:recommended
        'no-irregular-whitespace': "error", // eslint:recommended
        'no-obj-calls': "error", // eslint:recommended
        'no-prototype-builtins': "off",
        'no-regex-spaces': "error", // eslint:recommended
        'no-sparse-arrays': "error", // eslint:recommended
        'no-template-curly-in-string': "off",
        'no-unexpected-multiline': "error", // eslint:recommended
        'no-unreachable': "error", // eslint:recommended
        'no-unsafe-finally': "error", // eslint:recommended
        'no-unsafe-negation': "off",
        'use-isnan': "error", // eslint:recommended
        'valid-jsdoc': ["error", {
            "requireReturn": true,
            "requireReturnType": true,
            "requireParamDescription": false,
            "requireReturnDescription": false,
            "prefer": { "arg": "param", "argument": "param", "class": "constructor", "return": "return", "virtual": "abstract" }
        }],
        'valid-typeof': "error", // eslint:recommended


        // Best Practices
        // http://eslint.org/docs/rules/#best-practices
        // --------------------------------------------

        'accessor-pairs': "error",
        'array-callback-return': "error",
        'block-scoped-var': "error",
        'class-methods-use-this': "off",
        'complexity': ["error", 6],
        'consistent-return': "error",
        'curly': ["error", 'all'],
        'default-case': "error",
        'dot-location': [
            "error",
            'property'
        ],
        'dot-notation': "error",
        'eqeqeq': "error",
        'guard-for-in': "error",
        'no-alert': "error",
        'no-caller': "error",
        'no-case-declarations': "error", // eslint:recommended
        'no-div-regex': "error",
        'no-else-return': "error",
        'no-empty-function': "error",
        'no-empty-pattern': "error", // eslint:recommended
        'no-eq-null': "error",
        'no-eval': "error",
        'no-extend-native': "error",
        'no-extra-bind': "error",
        'no-extra-label': "error",
        'no-fallthrough': "error", // eslint:recommended
        'no-floating-decimal': "error",
        'no-global-assign': "error",
        'no-implicit-coercion': "error",
        'no-implicit-globals': "error",
        'no-implied-eval': "error",

        // 'no-invalid-this': "error",

        'no-iterator': "error",
        'no-labels': "error",
        'no-lone-blocks': "error",
        'no-loop-func': "error",
        'no-magic-numbers': ["error", { "ignore": [-1, 0, 1] }],
        'no-multi-spaces': "error",
        'no-multi-str': "off",
        'no-new': "error",
        'no-new-func': "error",
        'no-new-wrappers': "error",
        'no-octal': "error", // eslint:recommended
        'no-octal-escape': "error",
        'no-param-reassign': "error",
        'no-proto': "error",
        'no-redeclare': "error", // eslint:recommended
        'no-restricted-properties': "error",
        'no-return-assign': "error",
        'no-script-url': "error",
        'no-self-assign': "error", // eslint:recommended
        'no-self-compare': "error",
        'no-sequences': "error",
        'no-throw-literal': "error", // eslint:recommended
        'no-unmodified-loop-condition': "error",
        'no-unused-expressions': "error",
        'no-unused-labels': "error", // eslint:recommended
        'no-useless-call': "error",
        'no-useless-concat': "error",
        'no-useless-escape': "error",
        'no-void': "error",
        'no-warning-comments': "off",
        'no-with': "error",
        'prefer-promise-reject-errors': "error",
        'radix': "error",
        'require-await': "error",
        'vars-on-top': "error",
        'wrap-iife': "error",
        'yoda': "error",

        // Strict Mode
        // http://eslint.org/docs/rules/#strict-mode
        // -----------------------------------------
        'strict': "error",

        // Variables
        // http://eslint.org/docs/rules/#variables
        // ---------------------------------------
        'init-declarations': "off",
        'no-catch-shadow': "error",
        'no-delete-var': "error", // eslint:recommended
        'no-label-var': "error",
        'no-restricted-globals': "off",
        'no-shadow': "error",
        'no-shadow-restricted-names': "error",
        'no-undef': "error", // eslint:recommended
        'no-undef-init': "error",
        'no-undefined': "off",
        'no-unused-vars': ["error", {args: 'none'}], // eslint:recommended
        'no-use-before-define': ["error", {functions: false, classes: false, variables: true}],


        'array-bracket-newline': [
            "error",
            {'multiline': true}
        ], // eslint:recommended
        'array-bracket-spacing': "off",
        // 'array-element-newline': ["error", { "multiline": true }], // eslint:recommended
        'block-spacing': "error",
        'brace-style': "error",
        'camelcase': "error",
        'capitalized-comments': "off",
        'comma-dangle': [
            "error",
            {
                arrays: 'always-multiline',
                objects: 'always-multiline',
                imports: 'never',
                exports: 'never',
                functions: 'ignore'
            }
        ],
        'comma-spacing': "error",
        'comma-style': "error",
        'computed-property-spacing': "error",
        'consistent-this': ["error", 'self'],
        'eol-last': "error",
        'func-call-spacing': "error",
        'func-name-matching': "error",
        'func-names': "off",
        'func-style': "off",
        'id-blacklist': "off",
        'id-length': "off",
        'id-match': "off",
        'jsx-quotes': "off",
        'key-spacing': "error",
        'keyword-spacing': "error",
        'line-comment-position': "off",
        'lines-around-comment': "off",
        'max-depth': "error",
        'max-len': ["error", {
            code: 120,
            ignoreUrls: true
        }],
        'max-lines': "off",
        'max-nested-callbacks': "error",
        'max-params': "off",
        'max-statements': "off",
        'max-statements-per-line': "error",
        'multiline-ternary': [
            "error",
            'always-multiline'
        ],
        'new-cap': "error",
        'new-parens': "error",
        'newline-per-chained-call': ["error", {"ignoreChainWithDepth": 2}],
        'no-array-constructor': "error",
        'no-bitwise': "error",
        'no-continue': "off",
        'no-inline-comments': "off",
        'no-lonely-if': "error",
        'no-mixed-operators': "error",
        'no-mixed-spaces-and-tabs': "error", // eslint:recommended
        'no-multi-assign': "off",
        'no-multiple-empty-lines': ["error", {max: 2}],
        'no-negated-condition': "off",
        'no-nested-ternary': "error",
        'no-new-object': "error",
        'no-plusplus': "off",
        'no-restricted-syntax': "off",
        'no-tabs': "error",
        'no-ternary': "off",
        'no-trailing-spaces': ["error", {"skipBlankLines": true,"ignoreComments": true}],
        'no-underscore-dangle': "off",
        'no-unneeded-ternary': "error",
        'no-whitespace-before-property': "error",
        'nonblock-statement-body-position': "error",


        // 'object-curly-newline': ["error", {multiline: true}],


        'object-curly-spacing': "off",
        'object-property-newline': ["error", {"allowAllPropertiesOnSameLine": true}],
        'one-var': ["error", 'never'],
        'one-var-declaration-per-line': "error",
        'operator-assignment': "off",
        'operator-linebreak': "off",
        'padded-blocks': "off",
        'padding-line-between-statements': "off",
        'quote-props': ["error", 'consistent'],
        'require-jsdoc': "off",
        'semi-spacing': "error",
        'semi-style': "error",
        'sort-keys': "off",
        'sort-vars': "off",
        'space-before-blocks': "error",
        'space-before-function-paren': ["error", {
            asyncArrow: 'always',
            anonymous: 'ignore',
            named: 'never'
        }],
        'space-in-parens': "error",
        'space-infix-ops': "error",
        'space-unary-ops': "error",
        'spaced-comment': ["error", 'always'],
        'switch-colon-spacing': "error",
        'template-tag-spacing': "off",
        'unicode-bom': "off",
        'wrap-regex': "off",
    }
};